/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.api.handler.ICustomPlayerData;
import noppes.npcs.api.handler.capability.IPlayerDataHandler;
import noppes.npcs.api.wrapper.data.Data;
import noppes.npcs.controllers.data.PlayerBankData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerGameData;
import noppes.npcs.controllers.data.PlayerItemGiverData;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.controllers.data.PlayerMiniMapData;
import noppes.npcs.controllers.data.PlayerOverlayHUD;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAnimation;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.NBTJsonUtil;
import noppes.npcs.util.Util;

public class PlayerData
implements IPlayerDataHandler,
ICapabilityProvider,
ICustomPlayerData {
    @CapabilityInject(value=IPlayerDataHandler.class)
    public static Capability<IPlayerDataHandler> PLAYERDATA_CAPABILITY = null;
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "playerdata");
    private EntityNPCInterface activeCompanion = null;
    public PlayerBankData bankData;
    public NBTTagCompound cloned;
    public int companionID = 0;
    public PlayerDialogData dialogData;
    public int dialogId = -1;
    public EntityNPCInterface editingNpc;
    public PlayerFactionData factionData;
    public PlayerGameData game;
    public PlayerItemGiverData itemgiverData;
    public PlayerMailData mailData;
    public DataAnimation animation;
    public PlayerOverlayHUD hud;
    public PlayerQuestData questData;
    public PlayerScriptData scriptData;
    public PlayerMiniMapData minimap;
    public EntityPlayer player;
    public int playerLevel = 0;
    public ItemStack prevHeldItem;
    public final Data scriptStoreddata = new Data();
    public DataTimers timers;
    public PlayerTransportData transportData;
    public boolean updateClient = false;
    public String uuid = "";
    public String playername = "";

    public static PlayerData get(EntityPlayer player) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return CustomNpcs.proxy.getPlayerData(player);
        }
        PlayerData data = (PlayerData)player.getCapability(PLAYERDATA_CAPABILITY, null);
        if (data != null && data.player == null) {
            data.player = player;
            data.playerLevel = player.field_71068_ca;
            data.animation = new DataAnimation((EntityLivingBase)player);
            data.scriptData = new PlayerScriptData(player);
            NBTTagCompound compound = PlayerData.loadPlayerData(player.getPersistentID().toString(), player.func_70005_c_());
            if (compound.func_150296_c().isEmpty()) {
                compound = PlayerData.loadPlayerDataOld(player.getPersistentID().toString(), player.func_70005_c_());
            }
            data.setNBT(compound);
        }
        return data;
    }

    public static NBTTagCompound loadPlayerData(String uuid, String name) {
        File file;
        block12: {
            File dir = CustomNpcs.getWorldSaveDirectory("playerdata");
            File saveDir = new File(dir, uuid);
            file = new File(saveDir, name + ".json");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
                File oldVersionFile = new File(dir, uuid + ".json");
                try {
                    if (!oldVersionFile.exists()) break block12;
                    NBTTagCompound nbt = NBTJsonUtil.LoadFile(oldVersionFile);
                    oldVersionFile.delete();
                    if (!file.exists()) {
                        try {
                            file.createNewFile();
                            Util.instance.saveFile(file, nbt);
                        }
                        catch (Exception e) {
                            LogWriter.error("Error create player data: " + file.getAbsolutePath(), e);
                        }
                    }
                    return nbt;
                }
                catch (Exception e) {
                    LogWriter.error("Error old loading: " + oldVersionFile.getAbsolutePath(), e);
                }
            }
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                LogWriter.error("Error create player data: " + file.getAbsolutePath(), e);
            }
            return new NBTTagCompound();
        }
        try {
            if (file.exists()) {
                return NBTJsonUtil.LoadFile(file);
            }
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
        }
        return new NBTTagCompound();
    }

    public static NBTTagCompound loadPlayerDataOld(String uuid, String name) {
        File file;
        File saveDir = CustomNpcs.getWorldSaveDirectory("playerdata/" + uuid);
        if (name.isEmpty()) {
            name = "noplayername";
        }
        name = name + ".dat";
        try {
            file = new File(saveDir, name);
            if (file.exists()) {
                NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                file.delete();
                file = new File(saveDir, name + "_old");
                if (file.exists()) {
                    file.delete();
                }
                return comp;
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        try {
            file = new File(saveDir, name + "_old");
            if (file.exists()) {
                return CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        return new NBTTagCompound();
    }

    public static void register(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(key, (ICapabilityProvider)new PlayerData());
        }
    }

    public PlayerData() {
        this.dialogData = new PlayerDialogData();
        this.bankData = new PlayerBankData();
        this.questData = new PlayerQuestData();
        this.transportData = new PlayerTransportData();
        this.factionData = new PlayerFactionData();
        this.itemgiverData = new PlayerItemGiverData();
        this.mailData = new PlayerMailData();
        this.hud = new PlayerOverlayHUD();
        this.minimap = new PlayerMiniMapData();
        this.timers = new DataTimers(this);
        this.prevHeldItem = ItemStack.field_190927_a;
        this.game = new PlayerGameData();
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public NBTTagCompound getNBT() {
        NBTTagCompound nbt;
        CustomNpcs.debugData.start(this);
        if (this.player != null) {
            this.playername = this.player.func_70005_c_();
            this.uuid = this.player.getPersistentID().toString();
        }
        NBTTagCompound compound = new NBTTagCompound();
        this.dialogData.saveNBTData(compound);
        this.questData.saveNBTData(compound);
        this.transportData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        this.itemgiverData.saveNBTData(compound);
        this.mailData.saveNBTData(compound);
        this.timers.writeToNBT(compound);
        this.hud.saveNBTData(compound);
        this.game.saveNBTData(compound);
        this.minimap.saveNBTData(compound);
        if (this.animation != null) {
            this.animation.save(compound);
        }
        compound.func_74768_a("PlayerCompanionId", this.companionID);
        compound.func_74782_a("ScriptStoreddata", (NBTBase)this.scriptStoreddata.getNbt().getMCNBT());
        if (this.playername != null && !this.playername.isEmpty()) {
            compound.func_74778_a("PlayerName", this.playername);
        }
        if (this.uuid != null && !this.uuid.isEmpty()) {
            compound.func_74778_a("UUID", this.uuid);
        }
        if (this.hasCompanion() && this.activeCompanion.func_184198_c(nbt = new NBTTagCompound())) {
            compound.func_74782_a("PlayerCompanion", (NBTBase)nbt);
        }
        CustomNpcs.debugData.end(this);
        return compound;
    }

    public NBTTagCompound getSyncNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.dialogData.saveNBTData(compound);
        this.questData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        return compound;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == PLAYERDATA_CAPABILITY;
    }

    public boolean hasCompanion() {
        return this.activeCompanion != null && !this.activeCompanion.field_70128_L;
    }

    public synchronized void save(boolean update) {
        CustomNPCsScheduler.runTack(() -> {
            try {
                if (this.uuid.isEmpty()) {
                    this.uuid = "noplayeruuid";
                }
                if (this.playername.isEmpty()) {
                    this.playername = "noplayername";
                }
                File saveDir = CustomNpcs.getWorldSaveDirectory("playerdata/" + this.uuid);
                String filename = this.playername + ".json";
                File file = new File(saveDir, filename + "_new");
                File file1 = new File(saveDir, filename);
                NBTTagCompound nbt = this.getNBT();
                Util.instance.saveFile(file, nbt);
                if (file1.exists()) {
                    file1.delete();
                }
                file.renameTo(file1);
            }
            catch (Exception e) {
                LogWriter.error("Error save PlayerData to file", e);
            }
        });
        if (update) {
            this.updateClient = true;
        }
    }

    public void setCompanion(EntityNPCInterface npc) {
        if (npc == null || !(npc.advanced.roleInterface instanceof RoleCompanion)) {
            return;
        }
        ++this.companionID;
        this.activeCompanion = npc;
        ((RoleCompanion)npc.advanced.roleInterface).companionID = this.companionID;
        this.save(false);
    }

    @Override
    public void setNBT(NBTTagCompound data) {
        if (this.player != null) {
            this.playername = this.player.func_70005_c_();
            this.uuid = this.player.getPersistentID().toString();
        } else {
            this.playername = data.func_74779_i("PlayerName");
            this.uuid = data.func_74779_i("UUID");
        }
        this.dialogData.loadNBTData(data);
        this.bankData.loadNBTData(data, this.uuid);
        this.questData.loadNBTData(data);
        this.transportData.loadNBTData(data);
        this.factionData.loadNBTData(data);
        this.itemgiverData.loadNBTData(data);
        this.mailData.loadNBTData(data);
        this.hud.loadNBTData(data);
        this.timers.readFromNBT(data);
        this.game.readFromNBT(data);
        this.companionID = data.func_74762_e("PlayerCompanionId");
        if (data.func_74764_b("PlayerCompanion") && !this.hasCompanion()) {
            EntityCustomNpc npc = new EntityCustomNpc(this.player.field_70170_p);
            npc.func_70037_a(data.func_74775_l("PlayerCompanion"));
            npc.func_70107_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
            if (npc.advanced.roleInterface instanceof RoleCompanion) {
                this.setCompanion(npc);
                ((RoleCompanion)npc.advanced.roleInterface).setSitting(false);
                this.player.field_70170_p.func_72838_d((Entity)npc);
            }
        }
        this.scriptStoreddata.setNbt(data.func_74775_l("ScriptStoreddata"));
    }

    public void updateCompanion(World world) {
        if (!this.hasCompanion() || world == this.activeCompanion.field_70170_p) {
            return;
        }
        RoleCompanion role = (RoleCompanion)this.activeCompanion.advanced.roleInterface;
        role.owner = this.player;
        if (!role.isFollowing()) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.activeCompanion.func_184198_c(nbt);
        this.activeCompanion.field_70128_L = true;
        EntityCustomNpc npc = new EntityCustomNpc(world);
        npc.func_70037_a(nbt);
        npc.func_70107_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
        this.setCompanion(npc);
        ((RoleCompanion)npc.advanced.roleInterface).setSitting(false);
        world.func_72838_d((Entity)npc);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
        if (player != null) {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.animation != null) {
                this.animation.save(compound);
            }
            this.animation = new DataAnimation((EntityLivingBase)player);
            if (!compound.func_82582_d()) {
                this.animation.load(compound);
            }
        }
    }
}

